' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa ProductDB jest uywana do przesyania pozycji Product (zarwno pojedynczych egzemplarzy jak i list) do i z bazy danych.
''' </summary>
Public Class ProductDB

  ''' <summary>
  ''' Ukryj konstruktor aby unikn tworzenia egzemplarzy klasy ProductDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Pobiera list produktw z bazy danych, w oparciu o identyfikator kategorii, do ktrej odnosz si produkty.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych, dla ktrej maj by zwrcone produkty.</param>
  Public Shared Function GetProductList(ByVal categoryId As Integer) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocProductSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        If categoryId = -1 Then ' pobierz wszystkie produkty w Sekcji Administracyjnej 
          myCommand.Parameters.AddWithValue("@categoryId", DBNull.Value)
        Else ' pobierz produkty dla okreslonej kategorii na stronie
          myCommand.Parameters.AddWithValue("@categoryId", categoryId)
        End If

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca egzemplarz klasy <see cref="Product" />.
  ''' </summary>
  ''' <param name="id">Identyfikator produktu w bazie danych.</param>
  Public Shared Function [Get](ByVal id As Integer) As Product
    Dim theProduct As Product = Nothing
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand("sprocProductSelectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", id)

        myConnection.Open()
        Using myReader As SqlDataReader = myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            theProduct = New Product(myReader.GetInt32(myReader.GetOrdinal("Id")))
            theProduct.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            theProduct.TagLine = myReader.GetString(myReader.GetOrdinal("TagLine"))
            theProduct.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            theProduct.CategoryId = myReader.GetInt32(myReader.GetOrdinal("CategoryId"))
            If Not myReader.IsDBNull(myReader.GetOrdinal("ImageUrl")) Then
              theProduct.ImageUrl = myReader.GetString(myReader.GetOrdinal("ImageUrl"))
            End If
            If Not myReader.IsDBNull(myReader.GetOrdinal("Keywords")) Then
              theProduct.Keywords = myReader.GetString(myReader.GetOrdinal("Keywords"))
            End If
          End If
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return theProduct
  End Function

  ''' <summary>
  ''' Zapisuje obiekt Product w bazie danych.
  ''' </summary>
  ''' <param name="theProduct">Egzemplarz klasy <see cref="Product" /> ktry ma by zapisany w bazie danych.</param>
  Public Shared Sub Save(ByVal theProduct As Product)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocProductInsertUpdateSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      If theProduct.Id > 0 Then
        myCommand.Parameters.AddWithValue("@id", theProduct.Id)
      Else
        myCommand.Parameters.AddWithValue("@id", DBNull.Value)
      End If
      myCommand.Parameters.AddWithValue("@title", theProduct.Title)
      myCommand.Parameters.AddWithValue("@tagLine", theProduct.TagLine)
      myCommand.Parameters.AddWithValue("@description", theProduct.Description)
      myCommand.Parameters.AddWithValue("@categoryId", theProduct.CategoryId)
      If Not theProduct.ImageUrl = String.Empty Then
        myCommand.Parameters.AddWithValue("@imageUrl", theProduct.ImageUrl)
      Else
        myCommand.Parameters.AddWithValue("@imageUrl", DBNull.Value)
      End If
      If Not theProduct.Keywords = String.Empty Then
        myCommand.Parameters.AddWithValue("@keywords", theProduct.Keywords)
      Else
        myCommand.Parameters.AddWithValue("@keywords", DBNull.Value)
      End If

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub

  ''' <summary>
  ''' Usuwa Product z bazy danych.
  ''' </summary>
  ''' <param name="id">Identyfikator <see cref="Product" /> w bazie danych.</param>
  ''' <remarks></remarks>
  Public Shared Sub Delete(ByVal id As Integer)
    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

      Dim myCommand As SqlCommand = New SqlCommand("sprocProductDeleteSingleItem", myConnection)
      myCommand.CommandType = CommandType.StoredProcedure

      myCommand.Parameters.AddWithValue("@id", id)

      myConnection.Open()
      myCommand.ExecuteNonQuery()
      myConnection.Close()
    End Using
  End Sub
End Class
